/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.enchant.EnchantmentCyclic;
import com.lothrazar.cyclic.registry.EnchantRegistry;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.util.UtilChat;
import com.lothrazar.cyclic.util.UtilPlayer;
import com.lothrazar.cyclic.util.UtilSound;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class StandEnchant
extends EnchantmentCyclic {
    public static final String ID = "laststand";
    public static ForgeConfigSpec.BooleanValue CFG;
    public static ForgeConfigSpec.IntValue COST;
    public static ForgeConfigSpec.IntValue ABS;
    public static ForgeConfigSpec.IntValue COOLDOWN;

    public StandEnchant(Enchantment.Rarity rarityIn, EnchantmentCategory typeIn, EquipmentSlot ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean m_5975_(Enchantment ench) {
        return super.m_5975_(ench) && ench != EnchantRegistry.LAUNCH && ench != EnchantRegistry.EXPERIENCE_BOOST && ench != Enchantments.f_44962_ && ench != Enchantments.f_44972_;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public int m_6586_() {
        return 2;
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingDamageEvent event) {
        LivingEntity livingEntity;
        if (!this.isEnabled()) {
            return;
        }
        int level = this.getCurrentArmorLevelSlot(event.getEntityLiving(), EquipmentSlot.LEGS);
        if (level > 0 && event.getEntityLiving().m_21223_() - event.getAmount() <= 0.0f && (livingEntity = event.getEntityLiving()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if ((Integer)COOLDOWN.get() > 0 && player.m_36335_().m_41519_(player.m_6844_(EquipmentSlot.LEGS).m_41720_())) {
                return;
            }
            int xpCost = Math.max(1, (Integer)COST.get() / level);
            if (UtilPlayer.getExpTotal((Player)player) < (double)xpCost) {
                return;
            }
            float toSurvive = event.getEntityLiving().m_21223_() - 1.0f;
            event.setAmount(toSurvive);
            player.m_6756_(-1 * xpCost);
            UtilSound.playSoundFromServer(player, SoundRegistry.CHAOS_REAPER, 1.0f, 0.4f);
            UtilChat.sendStatusMessage((Player)player, "enchantment.cyclic.laststand.activated");
            if ((Integer)ABS.get() > 0) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, ((Integer)ABS.get()).intValue(), level - 1));
            }
            if ((Integer)COOLDOWN.get() > 0) {
                player.m_36335_().m_41524_(player.m_6844_(EquipmentSlot.LEGS).m_41720_(), ((Integer)COOLDOWN.get()).intValue());
            }
        }
    }
}

